/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.collections.Pair;

public class DynamicGraph<T> {
    private final Collection<T> m_nodesReady;
    private final Collection<T> m_nodesRunning;
    private final Collection<T> m_nodesFinished;
    private final ListMultiMap<T, Edge<T>> m_edges = Maps.newListMultiMap();
    private final ListMultiMap<T, Edge<T>> m_allEdges = Maps.newListMultiMap();

    public DynamicGraph() {
        this.m_nodesFinished = Sets.newLinkedHashSet();
        this.m_nodesReady = Sets.newLinkedHashSet();
        this.m_nodesRunning = Sets.newLinkedHashSet();
    }

    public boolean addNode(T t) {
        return this.m_nodesReady.add(t);
    }

    public void addEdge(int n, T t, T t2) {
        this.addEdges(Collections.singletonList(new Edge(n, t, t2)));
    }

    public void addEdge(int n, T t, T ... TArray) {
        this.addEdge(n, t, (Iterable<T>)Arrays.asList(TArray));
    }

    public void addEdge(int n, T t, Iterable<T> iterable) {
        List<Edge<T>> list = Lists.newArrayList();
        for (T t2 : iterable) {
            list.add(new Edge(n, t, t2));
        }
        this.addEdges(list);
    }

    private void addEdges(List<Edge<T>> list) {
        for (Edge<T> edge : list) {
            Edge<T> edge2 = DynamicGraph.getNode(this.m_edges, edge);
            if (edge2 != null && ((Edge)edge2).weight == ((Edge)edge).weight) {
                throw new IllegalStateException("Circular dependency: " + ((Edge)edge).from + " <-> " + ((Edge)edge).to);
            }
            if (edge2 == null || ((Edge)edge2).weight < ((Edge)edge).weight) {
                this.m_edges.put(((Edge)edge).from, edge);
            }
            this.m_allEdges.put(((Edge)edge).from, edge);
        }
    }

    private static <T> Edge<T> getNode(ListMultiMap<T, Edge<T>> listMultiMap, Edge<T> edge) {
        for (Edge edge2 : (List)listMultiMap.get(((Edge)edge).to)) {
            if (!edge2.to.equals(((Edge)edge).from)) continue;
            return edge2;
        }
        return null;
    }

    public List<T> getFreeNodes() {
        Object object;
        List<Object> list = Lists.newArrayList();
        for (Object object2 : this.m_nodesReady) {
            if (!((List)this.m_edges.get(object2)).isEmpty() && !this.getUnfinishedNodes(object2).isEmpty()) continue;
            list.add(object2);
        }
        if (list.isEmpty()) {
            int n = this.getLowestEdgePriority(this.m_nodesReady);
            for (Object e : this.m_nodesReady) {
                for (Object e2 : this.getUnfinishedNodes(e)) {
                    if (!this.m_nodesRunning.contains(e2)) continue;
                    return Collections.emptyList();
                }
                object = (List)this.m_edges.get(e);
                if (!DynamicGraph.hasAllEdgesWithLevel(object, n)) continue;
                list.add(e);
            }
        }
        List list2 = Lists.newArrayList();
        for (Object e : list) {
            object = (List)this.m_edges.get(e);
            boolean bl = true;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                if (!list.contains(edge.to)) continue;
                bl = false;
            }
            if (!bl) continue;
            list2.add(e);
        }
        return list2;
    }

    private int getLowestEdgePriority(Collection<T> collection) {
        if (collection.isEmpty()) {
            return 0;
        }
        Integer n = null;
        for (T t : collection) {
            for (Edge edge : (List)this.m_edges.get(t)) {
                if (n == null) {
                    n = edge.weight;
                    continue;
                }
                n = n < edge.weight ? n : edge.weight;
            }
        }
        return n == null ? 0 : n;
    }

    private static <T> boolean hasAllEdgesWithLevel(List<Edge<T>> list, int n) {
        for (Edge<T> edge : list) {
            if (((Edge)edge).weight == n) continue;
            return false;
        }
        return true;
    }

    private Collection<? extends T> getUnfinishedNodes(T t) {
        Set set = Sets.newHashSet();
        for (Edge edge : (List)this.m_edges.get(t)) {
            if (!this.m_nodesReady.contains(edge.to) && !this.m_nodesRunning.contains(edge.to)) continue;
            set.add(edge.to);
        }
        return set;
    }

    public void setStatus(Collection<T> collection, Status status) {
        for (T t : collection) {
            this.setStatus(t, status);
        }
    }

    public void setStatus(T t, Status status) {
        switch (status) {
            case RUNNING: {
                this.m_nodesReady.remove(t);
                this.m_nodesRunning.add(t);
                break;
            }
            case FINISHED: {
                this.m_nodesReady.remove(t);
                this.m_nodesRunning.remove(t);
                this.m_nodesFinished.add(t);
                this.m_edges.removeAll(t);
                List<Object> list = Lists.newArrayList();
                for (Map.Entry object : this.m_edges.entrySet()) {
                    for (Edge edge : (List)object.getValue()) {
                        if (!edge.to.equals(t)) continue;
                        list.add(new Pair(object.getKey(), edge));
                    }
                }
                for (Pair pair : list) {
                    for (Edge edge : (List)this.m_allEdges.get(t)) {
                        Edge edge2 = (Edge)pair.second();
                        Edge<T> edge3 = DynamicGraph.getNode(this.m_edges, new Edge(0, edge2.from, edge.to));
                        if (edge3 != null && ((Edge)edge3).weight <= edge2.weight || !this.m_nodesReady.contains(edge.to) || edge2.from.equals(edge.to)) continue;
                        if (edge.weight > edge2.weight) {
                            this.addEdge(edge.weight, (T)edge2.from, (T)edge.to);
                            continue;
                        }
                        this.addEdge(edge2.weight, (T)edge2.from, (T)edge.to);
                    }
                    this.m_edges.remove((T)pair.first(), (Edge<T>)pair.second());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status: " + (Object)((Object)status));
            }
        }
    }

    public int getNodeCount() {
        int n = this.m_nodesReady.size() + this.m_nodesRunning.size() + this.m_nodesFinished.size();
        return n;
    }

    public int getNodeCountWithStatus(Status status) {
        switch (status) {
            case READY: {
                return this.m_nodesReady.size();
            }
            case RUNNING: {
                return this.m_nodesRunning.size();
            }
            case FINISHED: {
                return this.m_nodesFinished.size();
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[DynamicGraph ");
        stringBuilder.append("\n  Ready:" + this.m_nodesReady);
        stringBuilder.append("\n  Running:" + this.m_nodesRunning);
        stringBuilder.append("\n  Finished:" + this.m_nodesFinished);
        stringBuilder.append("\n  Edges:\n");
        for (Map.Entry entry : this.m_edges.entrySet()) {
            stringBuilder.append("     " + entry.getKey() + "\n");
            for (Edge edge : (List)entry.getValue()) {
                stringBuilder.append("        " + edge.to + "\n");
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private String getName(T t) {
        String string = t.toString();
        int n = string.lastIndexOf(46) + 1;
        int n2 = string.indexOf(40);
        return string.substring(n, n2);
    }

    public String toDot() {
        String string;
        String string2 = "[style=filled color=yellow]";
        String string3 = "[style=filled color=green]";
        String string4 = "[style=filled color=grey]";
        StringBuilder stringBuilder = new StringBuilder("digraph g {\n");
        List<T> list = this.getFreeNodes();
        for (Object object : this.m_nodesReady) {
            string = list.contains(object) ? string2 : "";
            stringBuilder.append("  " + this.getName(object) + string + "\n");
        }
        for (Object object : this.m_nodesRunning) {
            string = list.contains(object) ? string2 : string3;
            stringBuilder.append("  " + this.getName(object) + string + "\n");
        }
        for (Object object : this.m_nodesFinished) {
            stringBuilder.append("  " + this.getName(object) + string4 + "\n");
        }
        stringBuilder.append("\n");
        for (Object object : this.m_edges.values()) {
            for (Edge edge : object) {
                String string5 = this.m_nodesFinished.contains(edge.from) ? "style=dotted" : "";
                stringBuilder.append("  " + this.getName(edge.from) + " -> " + this.getName(edge.to) + " [dir=back " + string5 + "]\n");
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public ListMultiMap<T, Edge<T>> getEdges() {
        return this.m_edges;
    }

    static class Edge<T> {
        private final T from;
        private final T to;
        private final int weight;

        private Edge(int n, T t, T t2) {
            this.from = t;
            this.to = t2;
            this.weight = n;
        }

        T getFrom() {
            return this.from;
        }

        T getTo() {
            return this.to;
        }
    }

    public static enum Status {
        READY,
        RUNNING,
        FINISHED;

    }
}

