/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.EmptyStackException;

public final class BooleanStack {
    private boolean[] data;
    private int size;

    public BooleanStack(int initialCapacity) {
        this.data = new boolean[initialCapacity];
        this.size = 0;
    }

    public BooleanStack() {
        this(5);
    }

    public void push(boolean t2) {
        if (this.size >= this.data.length) {
            this.data = ArrayUtil.realloc(this.data, this.data.length * 3 / 2);
        }
        this.data[this.size++] = t2;
    }

    public boolean pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.data[--this.size];
    }

    public boolean equals(Object o2) {
        if (o2 instanceof BooleanStack) {
            BooleanStack otherStack = (BooleanStack)o2;
            if (this.size != otherStack.size) {
                return false;
            }
            for (int i2 = 0; i2 < otherStack.size; ++i2) {
                if (this.data[i2] == otherStack.data[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOf(this.data, this.size));
    }
}

